package cc.polymorphism.obfuscator.mutator.impl.encryption.common.impl;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.expressions.IRExpressions;
import cc.polymorphism.assembly.expressions.IRVariable;
import cc.polymorphism.obfuscator.mutator.impl.encryption.common.IntCryptBlock;
import cc.polymorphism.obfuscator.mutator.impl.encryption.common.IntCryptData;
import cc.polymorphism.obfuscator.util.RandomUtils;

public class SimpleCryptBlock extends IntCryptBlock {
    private final Type type;

    private final int key;

    public SimpleCryptBlock() {
        this.type = RandomUtils.randomEnum(Type.class);
        this.key = RandomUtils.randomInt();
    }

    @Override
    public int encrypt(IntCryptData data, int integer) {
        return switch (type) {
            case SUBTRACTION -> integer - this.key;
            case ADDITION -> integer + this.key;
            case BINARY -> integer ^ this.key;
        };
    }

    @Override
    public int decrypt(IntCryptData data, int integer) {
        return switch (type) {
            case SUBTRACTION -> integer + this.key;
            case ADDITION -> integer - this.key;
            case BINARY -> integer ^ this.key;
        };
    }

    @Override
    public BytecodeBlock compile(IntCryptData data) {
        final BytecodeBlock block = new BytecodeBlock();

        final IRVariable var = data.variable();

        final IRExpression keyExpression = IRExpressions.intConstant(key);

        final IRExpression operation = switch (type) {
            case SUBTRACTION -> IRExpressions.intAdd(var, keyExpression);
            case ADDITION -> IRExpressions.intSub(var, keyExpression);
            case BINARY -> IRExpressions.intXor(var, keyExpression);
        };

        block.append(var.set(operation));

        return block;
    }

    private enum Type {
        SUBTRACTION, ADDITION, BINARY
    }
}
