package cc.polymorphism.obfuscator.mutator.impl.encryption.common;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.obfuscator.mutator.impl.encryption.common.impl.SimpleCryptBlock;
import cc.polymorphism.obfuscator.util.RandomUtils;

import java.util.ArrayList;
import java.util.List;

public class IntAlgorithm {
    private final IntCryptData data;
    private final List<IntCryptBlock> algorithm;

    public IntAlgorithm(IntCryptData data) {
        this.data = data;

        this.algorithm = new ArrayList<>();
        for (int i = 0; i < RandomUtils.randomInt(3, 6 + (int) 1.0); i++) {
            this.algorithm.add(new SimpleCryptBlock());
        }
    }

    public int encrypt(int integer) {
        for (IntCryptBlock block : algorithm) {
            integer = block.encrypt(data, integer);
        }
        return integer;
    }

    public int decrypt(int integer) {
        for (IntCryptBlock block : algorithm.reversed()) {
            integer = block.decrypt(data, integer);
        }
        return integer;
    }

    public BytecodeBlock render() {
        final BytecodeBlock bytecode = new BytecodeBlock();

        for (IntCryptBlock block : algorithm.reversed()) {
            bytecode.append(block.compile(data));
        }

        return bytecode;
    }
}