package cc.polymorphism.obfuscator.mutator;

import cc.polymorphism.obfuscator.Polymorphism;
import cc.polymorphism.obfuscator.logging.Logger;
import cc.polymorphism.obfuscator.mutator.impl.encryption.number.IntegerMutator;
import cc.polymorphism.obfuscator.mutator.impl.encryption.number.LongMutator;
import cc.polymorphism.obfuscator.mutator.impl.encryption.ref.ReferenceMutator;
import cc.polymorphism.obfuscator.mutator.impl.encryption.string.StringEncryptionMutator;
import cc.polymorphism.obfuscator.mutator.impl.misc.RenamingMutator;
import cc.polymorphism.obfuscator.structure.Manager;

import java.util.Arrays;

public class MutatorManager extends Manager<Mutator> {
    private final Polymorphism ctx;

    public MutatorManager(Polymorphism ctx) {
        this.ctx = ctx;
    }

    @Override
    public void init() {
        this.addAll(Arrays.asList(
                new RenamingMutator(ctx),
                new ReferenceMutator(ctx),
                new IntegerMutator(ctx),
                new LongMutator(ctx),
                new StringEncryptionMutator(ctx)
        ));
    }

    public void transform() {
        this.stream()
                .filter(Mutator::enabled)
                .forEach(transformer -> {
                    Logger.info("[Transformers] Executing: " + transformer.getName() + " (" + transformer.getConfigName() + ")");

                    long before = System.currentTimeMillis();
                    transformer.transform();
                    long after = System.currentTimeMillis();

                    Logger.info("[Transformers] Finished executing: " + transformer.getName() + " [" + (after - before) + "ms]");
                });
    }
}