package cc.polymorphism.obfuscator.exceptions.missing;

import cc.polymorphism.obfuscator.exceptions.obfuscation.PreventableObfuscationException;

public class MissingClassException extends PreventableObfuscationException {
    private MissingClassException(String className, boolean library) {
        super("Do NOT report this as an issue unless you have ensured the supposedly missing class is actually in at " +
                "least one of the provided libraries in your config.\n" + String.format(
                "Could not find \"%s\" in the %s.", className, library ? "classpath" : "input JAR classes"));
    }

    public static MissingClassException forInputClass(String className) {
        return new MissingClassException(className, false);
    }

    public static MissingClassException forLibraryClass(String className) {
        return new MissingClassException(className, true);
    }
}
