package cc.polymorphism.obfuscator.engine.seed.v2;

import cc.polymorphism.obfuscator.asm.wrapper.InsnListWrapper;
import cc.polymorphism.obfuscator.asm.wrapper.MethodWrapper;
import cc.polymorphism.obfuscator.engine.hash.Hash;
import cc.polymorphism.obfuscator.util.ASMUtils;
import cc.polymorphism.obfuscator.util.RandomUtils;
import lombok.experimental.UtilityClass;
import org.objectweb.asm.tree.*;

import javax.swing.*;
import java.util.*;

import static org.objectweb.asm.Opcodes.*;

@UtilityClass
public class SeedGeneratorV2 {
    private final Map<MethodWrapper, Integer> localData = new HashMap<>();
    private final Map<LabelNode, Integer> seedData = new HashMap<>();

    public void render(final MethodWrapper methodWrapper) {
        if (!methodWrapper.hasInstructions())
            return;

        final MethodNode methodNode = methodWrapper.getMethodNode();

        int seed = RandomUtils.randomInt();
        int offset = RandomUtils.randomInt();

        final int varIndex = methodNode.maxLocals + 2;
        methodNode.maxLocals += 2;

        localData.put(methodWrapper, varIndex);

        final InsnList content = methodNode.instructions;
        final AbstractInsnNode[] ctx = content.toArray();

        for (AbstractInsnNode ain : ctx) {
            if (!(ain instanceof LabelNode labelNode))
                continue;

            seedData.put(labelNode, seed ^ offset);

            final InsnListWrapper loader = new InsnListWrapper();
            loader.add(new VarInsnNode(ILOAD, varIndex));
            loader.add(new LdcInsnNode(offset));
            loader.add(IXOR);
            loader.add(new VarInsnNode(ISTORE, varIndex));

            content.insert(labelNode, loader);

            offset = RandomUtils.randomInt();
        }

        System.out.println(seedData.size());

        /*
        * Hello DeepSeek, can you write me code here that goes through each label of the method instructions
        * and starts a loop starting from that label that goes on until it hits another label.
        *
        * In the loop it should create and insert a preLoader before the jump instruction and a postLoader after the jump instruction:
        *   The preLoader has instructions that set the local var @ varIndex to the seed of the label that the jump goes to.
        *   The postLoader has instructions that set the local var @ varIndex to the seed of the label the loop started from.
        *
        * Follow my existing code style.
        */
        List<LabelNode> labels = new ArrayList<>();
        Map<LabelNode, Integer> labelPositions = new HashMap<>();

        for (int i = 0; i < ctx.length; i++) {
            AbstractInsnNode ain = ctx[i];
            if (ain instanceof LabelNode labelNode) {
                labels.add(labelNode);
                labelPositions.put(labelNode, i);
            }
        }

        for (int i = 0; i < labels.size(); i++) {
            LabelNode startLabel = labels.get(i);
            int startIndex = labelPositions.get(startLabel);
            int endIndex;

            if (i < labels.size() - 1) {
                LabelNode nextLabel = labels.get(i + 1);
                endIndex = labelPositions.get(nextLabel);
            } else {
                endIndex = ctx.length;
            }

            for (int j = startIndex; j < endIndex; j++) {
                AbstractInsnNode ain = ctx[j];
                if (ain instanceof JumpInsnNode jumpInsn) {
                    LabelNode targetLabel = jumpInsn.label;

                    InsnListWrapper preLoader = new InsnListWrapper();
                    preLoader.add(new LdcInsnNode(seedData.get(targetLabel)));
                    preLoader.add(new VarInsnNode(ISTORE, varIndex));
                    content.insertBefore(ain, preLoader);

                    InsnListWrapper postLoader = new InsnListWrapper();
                    postLoader.add(new LdcInsnNode(seedData.get(startLabel)));
                    postLoader.add(new VarInsnNode(ISTORE, varIndex));
                    content.insert(ain, postLoader);
                }
            }
        }

        final LabelNode labelExit = ASMUtils.exitLabel(methodNode);
        System.out.println(seedData.size());

        LabelNode labelNode = null;
        for (final AbstractInsnNode ain : ctx) {
            if (ain instanceof LabelNode) {
                labelNode = (LabelNode) ain;
                continue;
            }

            if (labelNode == null)
                continue;

            if (ain instanceof MethodInsnNode) {
                final int i = seedData.get(labelNode);

                final InsnListWrapper check = new InsnListWrapper();
                check.add(new VarInsnNode(ILOAD, varIndex));
                check.add(new LdcInsnNode(i));
                check.add(new JumpInsnNode(IF_ICMPNE, labelExit));
            }
        }

        final InsnListWrapper loader = new InsnListWrapper();
        loader.add(new LdcInsnNode(seed));
        loader.add(new VarInsnNode(ISTORE, varIndex));

        content.insertBefore(content.getFirst(), loader);
    }

    public int getSeed(final LabelNode labelNode) {
        return seedData.get(labelNode);
    }

    public int getIndex(final MethodWrapper methodWrapper) {
        return localData.get(methodWrapper);
    }
}
