package cc.polymorphism.obfuscator.engine.seed.renderer.impl;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpression;
import cc.polymorphism.assembly.expressions.IRExpressions;
import cc.polymorphism.assembly.expressions.IRVariable;
import cc.polymorphism.obfuscator.Polymorphism;
import cc.polymorphism.obfuscator.asm.wrapper.ClassWrapper;
import cc.polymorphism.obfuscator.asm.wrapper.MethodWrapper;
import cc.polymorphism.obfuscator.dictionary.Dictionary;
import cc.polymorphism.obfuscator.engine.hash.Hash;
import cc.polymorphism.obfuscator.engine.seed.Seed;
import cc.polymorphism.obfuscator.engine.seed.SeedBuilder;
import cc.polymorphism.obfuscator.engine.seed.renderer.SeedRenderer;
import cc.polymorphism.obfuscator.util.RandomUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

import java.util.Collections;

public class TraceSeedRenderer extends SeedRenderer {
    @Override
    public Seed render(Polymorphism ctx, Dictionary dictionary, Hash hash, Seed parent, ClassWrapper classWrapper, MethodWrapper methodWrapper) {
        final ClassNode classNode = classWrapper.getClassNode();
        final MethodNode methodNode = methodWrapper.getMethodNode();

        final int key = RandomUtils.randomInt();

        final IRVariable variable = new IRVariable(WrappedType.from(int.class), methodNode.maxLocals++);

        final BytecodeBlock block = new BytecodeBlock();

        final IRExpression hashCode = IRExpressions.invokeVirtual(
                IRExpressions.invokeVirtual(
                        IRExpressions.invokeVirtual(
                                IRExpressions.instance(
                                        WrappedType.from(Throwable.class),
                                        Collections.emptyList(),
                                        Collections.emptyList()
                                ),
                                "getStackTrace",
                                Collections.emptyList(),
                                WrappedType.from(StackTraceElement[].class)
                        ).getArrayElement(0),
                        WrappedType.from(StackTraceElement.class),
                        "getMethodName",
                        Collections.emptyList(),
                        Collections.emptyList(),
                        WrappedType.from(String.class)
                ),
                "hashCode",
                Collections.emptyList(),
                WrappedType.from(int.class)
        );

        if (parent == null) {
            block.append(variable.set(IRExpressions.intXor(
                    IRExpressions.intXor(
                            IRExpressions.getStatic(WrappedType.from(classNode), hash.getFieldNode().name, WrappedType.from(int.class)),
                            hashCode
                    ),
                    IRExpressions.intConstant(key)
            )));
        } else {
            block.append(variable.set(IRExpressions.intXor(
                    IRExpressions.intXor(
                            parent.getVariable(),
                            hashCode
                    ),
                    IRExpressions.intConstant(key)
            )));
        }

        final int value = parent == null
                ? hash.getValue() ^ methodNode.name.hashCode() ^ key
                : parent.getValue() ^ methodNode.name.hashCode() ^ key;

        return new SeedBuilder()
                .setClassWrapper(classWrapper)
                .setMethodWrapper(methodWrapper)
                .setVariable(variable)
                .setValue(value)
                .setBlock(block)
                .build();
    }
}