package cc.polymorphism.obfuscator.engine.seed.renderer.impl;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpressions;
import cc.polymorphism.assembly.expressions.IRVariable;
import cc.polymorphism.obfuscator.Polymorphism;
import cc.polymorphism.obfuscator.asm.wrapper.ClassWrapper;
import cc.polymorphism.obfuscator.asm.wrapper.MethodWrapper;
import cc.polymorphism.obfuscator.dictionary.Dictionary;
import cc.polymorphism.obfuscator.engine.hash.Hash;
import cc.polymorphism.obfuscator.engine.seed.Seed;
import cc.polymorphism.obfuscator.engine.seed.SeedBuilder;
import cc.polymorphism.obfuscator.engine.seed.renderer.SeedRenderer;
import cc.polymorphism.obfuscator.util.RandomUtils;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class RandomSeedRenderer extends SeedRenderer {
    @Override
    public Seed render(Polymorphism ctx, Dictionary dictionary, Hash hash, Seed parent, ClassWrapper classWrapper, MethodWrapper methodWrapper) {
        final ClassNode classNode = classWrapper.getClassNode();
        final MethodNode methodNode = methodWrapper.getMethodNode();

        final int key = RandomUtils.randomInt();

        final IRVariable variable = new IRVariable(WrappedType.from(int.class), methodNode.maxLocals++);

        final BytecodeBlock block = new BytecodeBlock();

        if (parent == null) {
            block.append(variable.set(IRExpressions.intXor(
                    IRExpressions.getStatic(WrappedType.from(classNode), hash.getFieldNode().name, WrappedType.from(int.class)),
                    IRExpressions.intConstant(key)
            )));
        } else {
            block.append(variable.set(IRExpressions.intXor(
                    parent.getVariable(),
                    IRExpressions.intConstant(key)
            )));
        }

        final int value = parent == null ? hash.getValue() ^ key : parent.getValue() ^ key;

        return new SeedBuilder()
                .setClassWrapper(classWrapper)
                .setMethodWrapper(methodWrapper)
                .setVariable(variable)
                .setValue(value)
                .setBlock(block)
                .build();
    }
}
