package cc.polymorphism.obfuscator.engine.seed.renderer.impl;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpressions;
import cc.polymorphism.assembly.expressions.IRVariable;
import cc.polymorphism.assembly.expressions.flow.IRTryCatchStructure;
import cc.polymorphism.assembly.instructions.InvokeNode;
import cc.polymorphism.assembly.instructions.RegisterNode;
import cc.polymorphism.assembly.instructions.SimpleNode;
import cc.polymorphism.assembly.std.Compiler;
import cc.polymorphism.obfuscator.Polymorphism;
import cc.polymorphism.obfuscator.asm.wrapper.ClassWrapper;
import cc.polymorphism.obfuscator.asm.wrapper.MethodWrapper;
import cc.polymorphism.obfuscator.dictionary.Dictionary;
import cc.polymorphism.obfuscator.engine.hash.Hash;
import cc.polymorphism.obfuscator.engine.seed.Seed;
import cc.polymorphism.obfuscator.engine.seed.SeedBuilder;
import cc.polymorphism.obfuscator.engine.seed.renderer.SeedRenderer;
import cc.polymorphism.obfuscator.util.RandomUtils;

import java.util.Collections;
import java.util.List;

public class ExceptionSeedRenderer extends SeedRenderer {
    private static ClassWrapper throwable;

    private static String throwableCallName;
    private static int throwableKey;

    @Override
    public Seed render(Polymorphism ctx, Dictionary dictionary, Hash hash, Seed parent, ClassWrapper classWrapper, MethodWrapper methodWrapper) {

        if (throwable == null) {
            final String throwableName = dictionary.next();
            final String throwableKeyName = dictionary.next();

            throwableCallName = dictionary.next();

            throwableKey = RandomUtils.randomInt();

            final String throwableCode = """
                    public class REPLACE_NAME extends RuntimeException {
                        private final String REPLACE_KEY_NAME;
                    
                        public REPLACE_NAME(final String REPLACE_KEY_NAME) {
                            this.REPLACE_KEY_NAME = REPLACE_KEY_NAME;
                        }
                    
                        @Override
                        public int hashCode() {
                            return this.REPLACE_KEY_NAME.hashCode() ^ new Throwable().getStackTrace()[1].getMethodName().hashCode() ^ REPLACE_KEY;
                        }
                    
                        public static void REPLACE_CALL_NAME(final String data) {
                            throw new REPLACE_NAME(data);
                        }
                    }
                    """
                    .replaceAll("REPLACE_NAME", throwableName)
                    .replaceAll("REPLACE_KEY_NAME", throwableKeyName)
                    .replaceAll("REPLACE_CALL_NAME", throwableCallName)
                    .replaceAll("REPLACE_KEY", String.valueOf(throwableKey));

            final Compiler compiler = new Compiler();

            throwable = new ClassWrapper(compiler.compile(throwableName, throwableCode), false);
        }

        final String data = dictionary.randomStr(16);

        final IRVariable variable = new IRVariable(WrappedType.from(int.class), methodWrapper.getMethodNode().maxLocals++);

        final BytecodeBlock tryBlock = new BytecodeBlock()
                .append(IRExpressions.invokeStatic(
                        throwable.getName(),
                        throwableCallName,
                        List.of(WrappedType.from(String.class)),
                        WrappedType.from(void.class),
                        IRExpressions.stringConstant(data)
                ));

        final BytecodeBlock catchBlock = new BytecodeBlock()
                .append(InvokeNode.invokeVirtual(
                        WrappedType.from(throwable.getClassNode()),
                        "hashCode",
                        Collections.emptyList(),
                        WrappedType.from(int.class)
                ));

        if (parent != null) {
            catchBlock.append(RegisterNode.loadVar(parent.getVariable()));
            catchBlock.append(SimpleNode.INT_XOR);
        }

        catchBlock.append(RegisterNode.storeVar(variable));

        final IRTryCatchStructure trap = (IRTryCatchStructure) IRExpressions.tryCatch(
                tryBlock,
                catchBlock,
                WrappedType.from(throwable.getClassNode())
        );

        final BytecodeBlock block = new BytecodeBlock()
                .append(variable.set(IRExpressions.intConstant(0)))
                .append(trap);

        int value = data.hashCode() ^ methodWrapper.getMethodNode().name.hashCode() ^ throwableKey;

        if (parent != null) {
            value ^= parent.getValue();
        }

        return new SeedBuilder()
                .setClassWrapper(classWrapper)
                .setMethodWrapper(methodWrapper)
                .setVariable(variable)
                .setValue(value)
                .addClass(throwable)
                .addTrap(methodWrapper.getMethodNode(), trap.getTryCatchBlockNode())
                .setBlock(block)
                .build();
    }
}
