package cc.polymorphism.obfuscator.engine.seed;

import cc.polymorphism.obfuscator.Polymorphism;
import cc.polymorphism.obfuscator.asm.wrapper.ClassWrapper;
import cc.polymorphism.obfuscator.asm.wrapper.MethodWrapper;
import cc.polymorphism.obfuscator.dictionary.Dictionary;
import cc.polymorphism.obfuscator.dictionary.DictionaryFactory;
import cc.polymorphism.obfuscator.engine.hash.Hash;
import cc.polymorphism.obfuscator.engine.seed.renderer.SeedRenderer;
import cc.polymorphism.obfuscator.engine.seed.renderer.impl.ExceptionSeedRenderer;
import cc.polymorphism.obfuscator.engine.seed.renderer.impl.RandomSeedRenderer;
import cc.polymorphism.obfuscator.engine.seed.renderer.impl.TraceSeedRenderer;
import cc.polymorphism.obfuscator.util.RandomUtils;

import java.util.ArrayList;
import java.util.List;

public class SeedGenerator {
    private final Dictionary dictionary = DictionaryFactory.defaultDictionary();

    private final Polymorphism ctx;

    private final List<SeedRenderer> renderers = List.of(
            new RandomSeedRenderer(),
            new TraceSeedRenderer(),
            new ExceptionSeedRenderer()
    );

    public SeedGenerator(Polymorphism ctx) {
        this.ctx = ctx;
    }

    public Seed generateSeed(Hash hash, ClassWrapper classWrapper, MethodWrapper methodWrapper) {
        if (!methodWrapper.getSeeds().isEmpty() && methodWrapper.getSeeds().getFirst() != null) {
            return generateSeed(methodWrapper.getSeeds().getFirst());
        }

        final Seed seed = renderers.get(RandomUtils.randomInt(renderers.size()))
                .render(ctx, dictionary, hash, null, classWrapper, methodWrapper);
        methodWrapper.getSeeds().add(seed);

        return seed;
    }

    public Seed generateSeed(Seed parent) {
        final ClassWrapper classWrapper = parent.getClassWrapper();
        final MethodWrapper methodWrapper = parent.getMethodWrapper();

        final Hash hash = classWrapper.getHash();

        final Seed seed = renderers.get(RandomUtils.randomInt(renderers.size()))
                .render(ctx, dictionary, hash, parent, classWrapper, methodWrapper);
        seed.setParent(parent);
        methodWrapper.getSeeds().add(seed);

        return seed;
    }

    public void render() {
        final List<ClassWrapper> classes = new ArrayList<>();

        ctx.getClasses().values().forEach(classWrapper -> classWrapper.methodStream().forEach(methodWrapper -> {
            for (Seed seed : methodWrapper.getSeeds().reversed()) {
                classes.addAll(seed.getClasses());
                seed.render();
            }
        }));

        classes.forEach(o -> {
            ctx.getClasses().put(o.getName(), o);
            ctx.getClasspath().put(o.getName(), o);
        });
    }
}