package cc.polymorphism.obfuscator.engine.seed;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.expressions.IRVariable;
import cc.polymorphism.obfuscator.asm.wrapper.ClassWrapper;
import cc.polymorphism.obfuscator.asm.wrapper.MethodWrapper;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

import java.util.List;
import java.util.Map;

@Getter
@Setter
@RequiredArgsConstructor
public class Seed {
    private Seed parent;

    private final ClassWrapper classWrapper;
    private final MethodWrapper methodWrapper;

    private final IRVariable variable;
    private final int value;

    private final List<ClassWrapper> classes;

    private final Map<ClassNode, FieldNode> fields;
    private final Map<ClassNode, MethodNode> methods;

    private final Map<MethodNode, TryCatchBlockNode> traps;

    private final BytecodeBlock block;

    public void render() {
        final MethodNode methodNode = methodWrapper.getMethodNode();

        this.fields.forEach((c, field) -> c.fields.add(field));
        this.methods.forEach((c, method) -> c.methods.add(method));

        methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), this.block.compile());

        this.traps.forEach((o, trap) -> o.tryCatchBlocks.add(trap));
    }
}
