package cc.polymorphism.obfuscator.engine.hash;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpressions;
import cc.polymorphism.obfuscator.Polymorphism;
import cc.polymorphism.obfuscator.asm.wrapper.ClassWrapper;
import cc.polymorphism.obfuscator.dictionary.Dictionary;
import cc.polymorphism.obfuscator.dictionary.DictionaryFactory;
import cc.polymorphism.obfuscator.util.ASMUtils;
import cc.polymorphism.obfuscator.util.RandomUtils;
import org.objectweb.asm.tree.FieldNode;

import java.util.*;

public class HashGenerator extends ASMUtils {
    private final Dictionary dictionary = DictionaryFactory.defaultDictionary();

    private final Polymorphism ctx;

    public HashGenerator(Polymorphism ctx) {
        this.ctx = ctx;
    }

    public Hash generate(ClassWrapper classWrapper) {
        if (classWrapper.getHash() != null) {
            return classWrapper.getHash();
        }

        final long seed = RandomUtils.randomLong();

        String fieldName;
        do {
            fieldName = dictionary.next();
        } while (classWrapper.containsFieldNode(fieldName, "I"));
        final FieldNode field = new FieldNode(ACC_PUBLIC | ACC_STATIC | ACC_FINAL, fieldName, "I", null, null);

        final BytecodeBlock blockInit = new BytecodeBlock();

        blockInit
                .append(IRExpressions.setStatic(
                        WrappedType.from(classWrapper.getClassNode()),
                        field.name,
                        WrappedType.from(int.class),
                        IRExpressions.invokeVirtual(
                                IRExpressions.instance(
                                        WrappedType.from(Random.class),
                                        List.of(WrappedType.from(long.class)),
                                        List.of(IRExpressions.longConstant(seed))
                                ),
                                "nextInt",
                                Collections.emptyList(),
                                WrappedType.from(int.class)
                        )
                ));

        int value = new Random(seed).nextInt();

        final Hash hash = new Hash(classWrapper, null, new HashMap<>(), new HashMap<>(), field, value, blockInit);

        classWrapper.setHash(hash);

        return hash;
    }

    public void render() {
        ctx.getClasses().values().forEach(classWrapper -> {
            final Hash hash = classWrapper.getHash();

            if (hash == null) {
                return;
            }

            hash.render();
        });
    }
}