package cc.polymorphism.obfuscator.engine.hash;

import cc.polymorphism.assembly.BytecodeBlock;
import cc.polymorphism.obfuscator.asm.wrapper.ClassWrapper;
import cc.polymorphism.obfuscator.util.ASMUtils;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

import java.util.Map;

@SuppressWarnings("ClassCanBeRecord")

@Getter
@Setter
@RequiredArgsConstructor
public class Hash {
    private final ClassWrapper classWrapper;

    private final Hash previous;

    private final Map<ClassNode, FieldNode> fields;
    private final Map<ClassNode, MethodNode> methods;

    private final FieldNode fieldNode;
    private final int value;

    private final BytecodeBlock block;

    public void render() {
        final ClassNode classNode = classWrapper.getClassNode();

        this.fields.forEach((c, field) -> c.fields.add(field));
        this.methods.forEach((c, method) -> c.methods.add(method));

        final MethodNode initializer = ASMUtils.findOrCreateInitializer(classNode);
        initializer.instructions.insertBefore(initializer.instructions.getFirst(), this.block.compile());

        classWrapper.addField(this.fieldNode);
    }
}
