package cc.polymorphism.obfuscator.dictionary.defined;

import cc.polymorphism.obfuscator.dictionary.Dictionary;

public class NumericDictionary implements Dictionary {
    private static final char[] CHARSET = "1234567890".toCharArray();
    private int index = 1;

    @Override
    public String next() {
        return Dictionary.toBijectiveBase(CHARSET, index++);
    }

    @Override
    public String randomStr(int length) {
        return Dictionary.randomString(CHARSET, length);
    }

    @Override
    public String configName() {
        return "numeric";
    }

    @Override
    public Dictionary copy() {
        return new NumericDictionary();
    }
}
