package cc.polymorphism.obfuscator.dictionary.defined;

import cc.polymorphism.obfuscator.dictionary.Dictionary;

public class CustomCharsetDictionary implements Dictionary {
    private final char[] charset;
    private int index = 1;

    public CustomCharsetDictionary(String charsetString) {
        charset = charsetString.toCharArray();
    }

    @Override
    public String next() {
        return Dictionary.toBijectiveBase(charset, index++);
    }

    @Override
    public String randomStr(int length) {
        return Dictionary.randomString(charset, length);
    }

    @Override
    public String configName() {
        // This is intentional
        return null;
    }

    @Override
    public Dictionary copy() {
        return new AlphabeticalDictionary();
    }
}