package cc.polymorphism.obfuscator.dictionary.defined;

import cc.polymorphism.obfuscator.dictionary.Dictionary;

import java.util.List;

public class AlphabeticalDictionary implements Dictionary {
    private static final List<String> BLACKLIST = List.of(
            "abstract",
            "assert",
            "boolean",
            "break",
            "byte",
            "case",
            "catch",
            "char",
            "class",
            "const",
            "continue",
            "default",
            "double",
            "do",
            "else",
            "enum",
            "extends",
            "false",
            "final",
            "finally",
            "float",
            "for",
            "goto",
            "if",
            "implements",
            "import",
            "instanceof",
            "int",
            "interface",
            "long",
            "native",
            "new",
            "null",
            "package",
            "private",
            "protected",
            "public",
            "return",
            "short",
            "static",
            "strictfp",
            "super",
            "switch",
            "synchronized",
            "this",
            "throw",
            "throws",
            "transient",
            "true",
            "try",
            "void",
            "volatile",
            "while"
    );

    private static final char[] CHARSET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private int index = 1;

    @Override
    public String next() {
        String result;
        do {
            result = Dictionary.toBijectiveBase(CHARSET, index++);
        } while (BLACKLIST.contains(result));
        return result;
    }

    @Override
    public String randomStr(int length) {
        return Dictionary.randomString(CHARSET, length);
    }

    @Override
    public String configName() {
        return "alphabetical";
    }

    @Override
    public Dictionary copy() {
        return new AlphabeticalDictionary();
    }
}
