package cc.polymorphism.obfuscator.dictionary;

import cc.polymorphism.obfuscator.dictionary.defined.AlphabeticalDictionary;
import cc.polymorphism.obfuscator.dictionary.defined.CustomCharsetDictionary;
import cc.polymorphism.obfuscator.dictionary.defined.NumericDictionary;

import java.util.stream.Stream;

public class DictionaryFactory {
    private static final Dictionary[] DEFINED = {
            new AlphabeticalDictionary(),
            new NumericDictionary()
    };

    public static Dictionary dictionaryOf(String string) {
        return Stream.of(DEFINED)
                .filter(dictionary -> string.equalsIgnoreCase(dictionary.configName()))
                .findFirst()
                .orElseGet(() -> new CustomCharsetDictionary(string));
    }

    public static Dictionary defaultDictionary() {
        return DictionaryFactory.dictionaryOf("alphabetical");
    }
}
