package cc.polymorphism.obfuscator.dictionary;

import cc.polymorphism.obfuscator.util.RandomUtils;

public interface Dictionary {
    String next();

    String randomStr(int length);

    String configName();

    Dictionary copy();

    static String toBijectiveBase(char[] charset, int decimal) {
        var sb = new StringBuilder();
        while (decimal-- > 0) {
            sb.insert(0, charset[decimal % charset.length]);
            decimal /= charset.length;
        }
        return sb.toString();
    }

    static String randomString(char[] charset, int length) {
        var charsetLength = charset.length;
        var buf = new char[length];

        for (int i = 0; i < length; i++) {
            buf[i] = charset[RandomUtils.randomInt(charsetLength)];
        }

        return new String(buf);
    }
}
