package cc.polymorphism.obfuscator.asm;

import cc.polymorphism.obfuscator.Polymorphism;
import cc.polymorphism.obfuscator.PolymorphismData;
import cc.polymorphism.obfuscator.exceptions.obfuscation.FatalObfuscationException;
import cc.polymorphism.obfuscator.logging.Logger;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarWriter {
    public void write(String path) {
        var polymorphism = Polymorphism.getInstance();

        var classes = polymorphism.getClasses();
        var resources = polymorphism.getResources();

        Logger.info(String.format("Writing output to \"%s\"", path));
        var file = new File(path);

        try {
            var stream = new ZipOutputStream(new FileOutputStream(file));

            stream.setLevel(0);
            classes.forEach(((name, wrapper) -> {
                try {
                    var entry = new ZipEntry(wrapper.getName() + ".class");
                    var data = wrapper.toByteArray();
                    writeEntry(stream, entry, data);
                } catch (Throwable t) {
                    Logger.warn(String.format("An error happened while writing class \"%s\"", name));

                    if (PolymorphismData.VERBOSE) {
                        t.printStackTrace(System.err);
                    }
                }
            }));

            resources.forEach((name, data) -> {
                try {
                    writeEntry(stream, new ZipEntry(name), data);
                } catch (IOException ioe) {
                    Logger.warn(String.format("An IO error happened while writing resource \"%s\"", name));

                    if (PolymorphismData.VERBOSE) {
                        ioe.printStackTrace(System.err);
                    }
                }
            });

            stream.close();
        } catch (IOException ioe) {
            if (PolymorphismData.VERBOSE) {
                ioe.printStackTrace(System.err);
            }

            throw new FatalObfuscationException("An IO error happened while writing output: " + ioe.getMessage());
        }
    }

    private void writeEntry(ZipOutputStream stream, ZipEntry entry, byte[] data) throws IOException {
        stream.putNextEntry(entry);
        stream.write(data);
        stream.closeEntry();
    }
}
