package cc.polymorphism.common.matcher.rules;

import cc.polymorphism.common.TestingUtils;
import cc.polymorphism.common.matcher.InstructionPattern;
import org.junit.Assert;
import org.junit.Test;

import java.util.concurrent.ThreadLocalRandom;

public class LongConstRuleTester {
    @Test
    public void testMatch() {
        var examples = new long[]{
                0L,
                1L,
                ThreadLocalRandom.current().nextLong()
        };

        for (var example : examples) {
            var pattern = new InstructionPattern(new LongConstRule());
            var matcher = pattern.matcher(TestingUtils.loadLong(example));
            Assert.assertTrue(matcher.matches());
            Assert.assertTrue(matcher.find());
        }
    }
}
