package cc.polymorphism.common.matcher.rules;

import cc.polymorphism.common.TestingUtils;
import cc.polymorphism.common.matcher.InstructionPattern;
import org.junit.Assert;
import org.junit.Test;

import java.util.concurrent.ThreadLocalRandom;

public class IntConstRuleTester {
    @Test
    public void testMatch() {
        var examples = new int[]{
                -1,
                0,
                1,
                2,
                3,
                4,
                5,
                ThreadLocalRandom.current().nextInt(5, Byte.MAX_VALUE),
                ThreadLocalRandom.current().nextInt(Byte.MAX_VALUE + 1, Short.MAX_VALUE),
                ThreadLocalRandom.current().nextInt(Short.MAX_VALUE + 1, Integer.MAX_VALUE)
        };

        for (var example : examples) {
            var pattern = new InstructionPattern(new IntConstRule());
            var matcher = pattern.matcher(TestingUtils.loadInt(example));
            Assert.assertTrue(matcher.matches());
            Assert.assertTrue(matcher.find());
        }
    }
}
