package cc.polymorphism.common.matcher.rules;

import cc.polymorphism.common.TestingUtils;
import cc.polymorphism.common.matcher.InstructionPattern;
import org.junit.Assert;
import org.junit.Test;

import java.util.concurrent.ThreadLocalRandom;

public class FloatConstRuleTester {
    @Test
    public void testMatch() {
        var examples = new float[]{
                0F,
                1F,
                2F,
                ThreadLocalRandom.current().nextFloat()
        };

        for (var example : examples) {
            var pattern = new InstructionPattern(new FloatConstRule());
            var matcher = pattern.matcher(TestingUtils.loadFloat(example));
            Assert.assertTrue(matcher.matches());
            Assert.assertTrue(matcher.find());
        }
    }
}
