package cc.polymorphism.common.matcher.rules;

import cc.polymorphism.common.TestingUtils;
import cc.polymorphism.common.matcher.InstructionPattern;
import org.junit.Assert;
import org.junit.Test;

import java.util.concurrent.ThreadLocalRandom;

public class DoubleConstRuleTester {
    @Test
    public void testMatch() {
        var examples = new double[]{
                0D,
                1D,
                ThreadLocalRandom.current().nextDouble()
        };

        for (var example : examples) {
            var pattern = new InstructionPattern(new DoubleConstRule());
            var matcher = pattern.matcher(TestingUtils.loadDouble(example));
            Assert.assertTrue(matcher.matches());
            Assert.assertTrue(matcher.find());
        }
    }
}
