package cc.polymorphism.common.matcher;

import cc.polymorphism.common.matcher.rules.InvocationRule;
import cc.polymorphism.common.matcher.rules.OpcodeRule;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

import java.nio.charset.Charset;

public class InstructionMatcherTester {
    @Test
    public void testMatchMethodInvocationAndArgs() {
        var insns = new InsnList();
        insns.add(new LdcInsnNode("tucks"));
        insns.add(new LdcInsnNode("tux"));
        insns.add(new InsnNode(Opcodes.ACONST_NULL));
        insns.add(new MethodInsnNode(Opcodes.INVOKEVIRTUAL, "java/lang/String", "getBytes", Type.getInternalName(Charset.class), false));

        var pattern = new InstructionPattern(
                new OpcodeRule((node) -> node instanceof LdcInsnNode && ((LdcInsnNode) node).cst.equals("tux"), Opcodes.LDC),
                new OpcodeRule(Opcodes.ACONST_NULL),
                new InvocationRule(Opcodes.INVOKEVIRTUAL, "java/lang/String", "getBytes", Type.getInternalName(Charset.class))
        );
        var matcher = pattern.matcher(insns.getFirst());
        Assert.assertFalse(matcher.matches());
        Assert.assertTrue(matcher.find());

        var captured = matcher.getCaptured(0);
        insns.remove(insns.getFirst());
        for (var i = 0; i < insns.size(); i++) {
            Assert.assertEquals(insns.get(i), captured.get(i));
        }
    }
}
