package cc.polymorphism.common.matcher.rules;

import cc.polymorphism.common.matcher.InstructionMatcher;
import org.objectweb.asm.tree.AbstractInsnNode;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OpcodeRule implements InstructionRule {
    private final Function<AbstractInsnNode, Boolean> rule;
    private final List<Integer> wantedOpcodes;

    public OpcodeRule(Function<AbstractInsnNode, Boolean> rule, int... opcodes) {
        this.rule = rule;
        this.wantedOpcodes = Arrays.stream(opcodes).boxed().collect(Collectors.toList());
    }

    public OpcodeRule(int... opcodes) {
        this.rule = null;
        this.wantedOpcodes = Arrays.stream(opcodes).boxed().collect(Collectors.toList());
    }

    @Override
    public boolean matches(InstructionMatcher matcher, AbstractInsnNode current) {
        return wantedOpcodes.contains(current.getOpcode()) && (rule == null || rule.apply(current));
    }
}
