package cc.polymorphism.common.matcher.rules;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.LdcInsnNode;

public class LongConstRule extends OpcodeRule {
    public LongConstRule() {
        super(current -> {
                    if (current instanceof LdcInsnNode && !(((LdcInsnNode) current).cst instanceof Long)) {
                        return false;
                    }
                    return true;
                }, Opcodes.LCONST_0,
                Opcodes.LCONST_1,
                Opcodes.LDC
        );
    }
}
