package cc.polymorphism.common.matcher.rules;

import cc.polymorphism.common.matcher.InstructionMatcher;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

import java.util.function.Function;

public class InvocationRule extends OpcodeRule {
    private final int opcode;
    private final String owner;
    private final String name;
    private final String description;

    public InvocationRule(Function<AbstractInsnNode, Boolean> rule, int opcode, String owner, String name, String description) {
        super(rule, Opcodes.INVOKEVIRTUAL, Opcodes.INVOKESPECIAL, Opcodes.INVOKESTATIC, Opcodes.INVOKEINTERFACE);
        this.opcode = opcode;
        this.owner = owner;
        this.name = name;
        this.description = description;
    }

    public InvocationRule(int opcode, String owner, String name, String description) {
        super(null, Opcodes.INVOKEVIRTUAL, Opcodes.INVOKESPECIAL, Opcodes.INVOKESTATIC, Opcodes.INVOKEINTERFACE);
        this.opcode = opcode;
        this.owner = owner;
        this.name = name;
        this.description = description;
    }

    @Override
    public boolean matches(InstructionMatcher matcher, AbstractInsnNode current) {
        if (current.getOpcode() == opcode && current instanceof MethodInsnNode) {
            var casted = (MethodInsnNode) current;
            return (owner == null || owner.equals(casted.owner))
                    && (name == null || name.equals(casted.name))
                    && (description == null || description.equals(casted.desc));
        }
        return false;
    }
}
