package cc.polymorphism.common.matcher.rules;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.LdcInsnNode;

public class IntConstRule extends OpcodeRule {
    public IntConstRule() {
        super(current -> {
                    if (current instanceof LdcInsnNode && !(((LdcInsnNode) current).cst instanceof Integer)) {
                        return false;
                    }
                    return true;
                }, Opcodes.ICONST_M1,
                Opcodes.ICONST_0,
                Opcodes.ICONST_1,
                Opcodes.ICONST_2,
                Opcodes.ICONST_3,
                Opcodes.ICONST_4,
                Opcodes.ICONST_5,
                Opcodes.BIPUSH,
                Opcodes.SIPUSH,
                Opcodes.LDC
        );
    }
}
