package cc.polymorphism.common.matcher.rules;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.LdcInsnNode;

public class FloatConstRule extends OpcodeRule {
    public FloatConstRule() {
        super(current -> {
                    if (current instanceof LdcInsnNode && !(((LdcInsnNode) current).cst instanceof Float)) {
                        return false;
                    }
                    return true;
                }, Opcodes.FCONST_0,
                Opcodes.FCONST_1,
                Opcodes.FCONST_2,
                Opcodes.LDC
        );
    }
}
