package cc.polymorphism.common.matcher.rules;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.LdcInsnNode;

public class DoubleConstRule extends OpcodeRule {
    public DoubleConstRule() {
        super(current -> {
                    if (current instanceof LdcInsnNode && !(((LdcInsnNode) current).cst instanceof Double)) {
                        return false;
                    }
                    return true;
                }, Opcodes.DCONST_0,
                Opcodes.DCONST_1,
                Opcodes.LDC
        );
    }
}
