package cc.polymorphism.common.matcher.rules;

import cc.polymorphism.common.matcher.InstructionMatcher;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;

import java.util.function.Function;

public class AccessFieldRule extends OpcodeRule {
    private final int opcode;
    private final String owner;
    private final String name;
    private final String description;

    public AccessFieldRule(Function<AbstractInsnNode, Boolean> rule, int opcode, String owner, String name, String description) {
        super(rule, Opcodes.GETFIELD, Opcodes.GETSTATIC, Opcodes.PUTFIELD, Opcodes.PUTSTATIC);
        this.opcode = opcode;
        this.owner = owner;
        this.name = name;
        this.description = description;
    }

    public AccessFieldRule(int opcode, String owner, String name, String description) {
        super(null, Opcodes.GETFIELD, Opcodes.GETSTATIC, Opcodes.PUTFIELD, Opcodes.PUTSTATIC);
        this.opcode = opcode;
        this.owner = owner;
        this.name = name;
        this.description = description;
    }

    @Override
    public boolean matches(InstructionMatcher matcher, AbstractInsnNode current) {
        if (current.getOpcode() == opcode && current instanceof FieldInsnNode) {
            var casted = (FieldInsnNode) current;
            return (owner == null || owner.equals(casted.owner))
                    && (name == null || name.equals(casted.name))
                    && (description == null || description.equals(casted.desc));
        }
        return false;
    }
}
