package cc.polymorphism.common.matcher;

import cc.polymorphism.common.matcher.rules.InstructionRule;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;

import java.util.List;

public class InstructionPattern {
    private final List<InstructionRule> rules;

    public InstructionPattern(@NotNull InstructionRule... rules) {
        this.rules = List.of(rules);
    }

    public List<InstructionRule> getRules() {
        return rules;
    }

    public InstructionMatcher matcher(AbstractInsnNode start) {
        return new InstructionMatcher(this, start);
    }
}
