package cc.polymorphism.assembly.instructions;

import cc.polymorphism.assembly.WrappedType;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.TypeInsnNode;

public class TypeNodeTester {
    @Test
    public void testNewInstanceForCorrectOpcode() {
        Assert.assertEquals(Opcodes.NEW, TypeNode.newInstance(WrappedType.from(String.class)).getNode().getOpcode());
    }

    @Test
    public void testNewInstanceForValidType() {
        Assert.assertEquals("java/lang/String", ((TypeInsnNode) TypeNode.newInstance(WrappedType.from(String.class)).getNode()).desc);
    }
}
