package cc.polymorphism.assembly.instructions;

import cc.polymorphism.assembly.WrappedType;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class NewArrayNodeTester {
    @Test
    public void testPrimitiveArrayType() {
        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(boolean.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_BOOLEAN, ((IntInsnNode) new NewArrayNode(WrappedType.from(boolean.class)).getNode()).operand);

        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(char.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_CHAR, ((IntInsnNode) new NewArrayNode(WrappedType.from(char.class)).getNode()).operand);

        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(byte.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_BYTE, ((IntInsnNode) new NewArrayNode(WrappedType.from(byte.class)).getNode()).operand);

        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(short.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_SHORT, ((IntInsnNode) new NewArrayNode(WrappedType.from(short.class)).getNode()).operand);

        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(int.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_INT, ((IntInsnNode) new NewArrayNode(WrappedType.from(int.class)).getNode()).operand);

        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(long.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_LONG, ((IntInsnNode) new NewArrayNode(WrappedType.from(long.class)).getNode()).operand);

        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(float.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_FLOAT, ((IntInsnNode) new NewArrayNode(WrappedType.from(float.class)).getNode()).operand);

        Assert.assertEquals(Opcodes.NEWARRAY, new NewArrayNode(WrappedType.from(double.class)).getNode().getOpcode());
        Assert.assertEquals(Opcodes.T_DOUBLE, ((IntInsnNode) new NewArrayNode(WrappedType.from(double.class)).getNode()).operand);
    }

    @Test
    public void testNonPrimitiveArrayType() {
        Assert.assertEquals(Opcodes.ANEWARRAY, new NewArrayNode(WrappedType.from(String.class)).getNode().getOpcode());
        Assert.assertEquals("java/lang/String", ((TypeInsnNode) new NewArrayNode(WrappedType.from(String.class)).getNode()).desc);

        Assert.assertEquals(Opcodes.ANEWARRAY, new NewArrayNode(WrappedType.from(Integer.class)).getNode().getOpcode());
        Assert.assertEquals("java/lang/Integer", ((TypeInsnNode) new NewArrayNode(WrappedType.from(Integer.class)).getNode()).desc);
    }
}
