package cc.polymorphism.assembly.instructions;

import cc.polymorphism.assembly.WrappedType;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

public class ConstantNodeTester {
    @Test
    public void testNullConst() {
        Assert.assertNull(ConstantNode.nullConst().getValue());
        Assert.assertEquals(Opcodes.ACONST_NULL, ConstantNode.nullConst().getNode().getOpcode());
    }

    @Test
    public void testBooleanConst() {
        Assert.assertTrue((Boolean) ConstantNode.booleanConst(true).getValue());
        Assert.assertNotEquals(Opcodes.ICONST_0, ConstantNode.booleanConst(true).getNode().getOpcode());
        Assert.assertFalse((Boolean) ConstantNode.booleanConst(false).getValue());
        Assert.assertEquals(Opcodes.ICONST_0, ConstantNode.booleanConst(false).getNode().getOpcode());
    }

    @Test
    public void testIntConst() {
        Assert.assertEquals(Integer.MIN_VALUE, ConstantNode.intConst(Integer.MIN_VALUE).getValue());
        Assert.assertEquals(Opcodes.LDC, ConstantNode.intConst(Integer.MIN_VALUE).getNode().getOpcode());
        Assert.assertEquals(Opcodes.SIPUSH, ConstantNode.intConst(Short.MIN_VALUE).getNode().getOpcode());
        Assert.assertEquals(Opcodes.BIPUSH, ConstantNode.intConst(Byte.MIN_VALUE).getNode().getOpcode());
        Assert.assertEquals(Opcodes.ICONST_M1, ConstantNode.intConst(-1).getNode().getOpcode());
    }

    @Test
    public void testFloatConst() {
        Assert.assertEquals(Float.MIN_VALUE, ConstantNode.floatConst(Float.MIN_VALUE).getValue());
        Assert.assertEquals(Opcodes.LDC, ConstantNode.floatConst(Float.MIN_VALUE).getNode().getOpcode());
        Assert.assertEquals(Opcodes.FCONST_0, ConstantNode.floatConst(0F).getNode().getOpcode());
    }

    @Test
    public void testDoubleConst() {
        Assert.assertEquals(Double.MIN_VALUE, ConstantNode.doubleConst(Double.MIN_VALUE).getValue());
        Assert.assertEquals(Opcodes.LDC, ConstantNode.doubleConst(Double.MIN_VALUE).getNode().getOpcode());
        Assert.assertEquals(Opcodes.DCONST_0, ConstantNode.doubleConst(0D).getNode().getOpcode());
    }

    @Test
    public void testStringConst() {
        Assert.assertEquals("tucks", ConstantNode.stringConst("tucks").getValue());
        Assert.assertEquals(Opcodes.LDC, ConstantNode.stringConst("tux").getNode().getOpcode());
    }

    @Test
    public void testClassConst() {
        Assert.assertEquals(WrappedType.from(String.class), ConstantNode.classConst(WrappedType.from(String.class)).getValue());
    }
}
