package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.GenerationContext;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRSetVariableExpressionTester {
    @Test
    public void testSetIntTypeVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(byte.class).set(intConstant(0)).bake().compile();
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ISTORE, insns.get(1).getOpcode());
    }

    @Test
    public void testSetLongVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(long.class).set(longConstant(0L)).bake().compile();
        Assert.assertEquals(Opcodes.LCONST_0, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.LSTORE, insns.get(1).getOpcode());
    }

    @Test
    public void testSetFloatVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(float.class).set(floatConstant(0F)).bake().compile();
        Assert.assertEquals(Opcodes.FCONST_0, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.FSTORE, insns.get(1).getOpcode());
    }

    @Test
    public void testSetDoubleVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(double.class).set(doubleConstant(0)).bake().compile();
        Assert.assertEquals(Opcodes.DCONST_0, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.DSTORE, insns.get(1).getOpcode());
    }

    @Test
    public void testSetObjectVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(String.class).set(stringConstant("tucks")).bake().compile();
        Assert.assertEquals(Opcodes.LDC, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ASTORE, insns.get(1).getOpcode());
    }
}
