package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.WrappedType;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldInsnNode;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRSetFieldExpressionTester {
    @Test
    public void testSetObjectField() throws Exception {
        var fin = (FieldInsnNode) setField(nullConstant(WrappedType.from(IRSetFieldExpressionTester.TestClass.class)), IRSetFieldExpressionTester.TestClass.class.getField("exampleField"), nullConstant(String.class)).bake().compile().get(2);
        Assert.assertEquals(Opcodes.PUTFIELD, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(IRSetFieldExpressionTester.TestClass.class), fin.owner);
        Assert.assertEquals("exampleField", fin.name);
        Assert.assertEquals("Ljava/lang/String;", fin.desc);
    }

    @Test
    public void testSetPrimitiveField() throws Exception {
        var fin = (FieldInsnNode) setField(nullConstant(WrappedType.from(IRSetFieldExpressionTester.TestClass.class)), IRSetFieldExpressionTester.TestClass.class.getField("examplePrimitiveField"), intConstant(0)).bake().compile().get(2);
        Assert.assertEquals(Opcodes.PUTFIELD, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(IRSetFieldExpressionTester.TestClass.class), fin.owner);
        Assert.assertEquals("examplePrimitiveField", fin.name);
        Assert.assertEquals("B", fin.desc);
    }

    @Test
    public void testSetObjectStatic() throws Exception {
        var fin = (FieldInsnNode) setStatic(
                IRSetFieldExpressionTester.TestClass.class.getField("exampleStaticField"),
                nullConstant(String.class)
        ).bake().compile().get(1);
        Assert.assertEquals(Opcodes.PUTSTATIC, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(IRSetFieldExpressionTester.TestClass.class), fin.owner);
        Assert.assertEquals("exampleStaticField", fin.name);
        Assert.assertEquals("Ljava/lang/String;", fin.desc);
    }

    @Test
    public void testSetPrimitiveStatic() throws Exception {
        var fin = (FieldInsnNode) setStatic(IRSetFieldExpressionTester.TestClass.class.getField("exampleStaticPrimitiveField"), intConstant(0)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.PUTSTATIC, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(IRSetFieldExpressionTester.TestClass.class), fin.owner);
        Assert.assertEquals("exampleStaticPrimitiveField", fin.name);
        Assert.assertEquals("B", fin.desc);
    }

    public static class TestClass {
        public String exampleField;
        public byte examplePrimitiveField;
        public static String exampleStaticField;
        public static byte exampleStaticPrimitiveField;
    }
}
