package cc.polymorphism.assembly.expressions.predefined;

import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRSetArrayElementExpressionTester {
    @Test
    public void testStoreBooleanElement() {
        var block = setArrayElement(nullConstant(boolean.class), intConstant(0), booleanConstant(false)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.IASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreByteElement() {
        var block = setArrayElement(nullConstant(byte.class), intConstant(0), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.BASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreShortElement() {
        var block = setArrayElement(nullConstant(short.class), intConstant(0), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.SASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreCharElement() {
        var block = setArrayElement(nullConstant(char.class), intConstant(0), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.CASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreIntElement() {
        var block = setArrayElement(nullConstant(int.class), intConstant(0), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.IASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreLongElement() {
        var block = setArrayElement(nullConstant(long.class), intConstant(0), longConstant(0L)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.LCONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.LASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreFloatElement() {
        var block = setArrayElement(nullConstant(float.class), intConstant(0), floatConstant(0F)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.FCONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.FASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreDoubleElement() {
        var block = setArrayElement(nullConstant(double.class), intConstant(0), doubleConstant(0D)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.DCONST_0, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.DASTORE, insns.get(3).getOpcode());
    }

    @Test
    public void testStoreObjectElement() {
        var block = setArrayElement(nullConstant(String.class), intConstant(0), nullConstant(String.class)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(2).getOpcode());
        Assert.assertEquals(Opcodes.AASTORE, insns.get(3).getOpcode());
    }
}
