package cc.polymorphism.assembly.expressions.predefined;

import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRReturnExpressionTester {
    @Test
    public void testReturnBoolean() {
        Assert.assertEquals(Opcodes.IRETURN, returnMe(booleanConstant(false)).bake().compile().get(1).getOpcode());
    }

    @Test
    public void testReturnInt() {
        Assert.assertEquals(Opcodes.IRETURN, returnMe(intConstant(0)).bake().compile().get(1).getOpcode());
    }

    @Test
    public void testReturnLong() {
        Assert.assertEquals(Opcodes.LRETURN, returnMe(longConstant(0L)).bake().compile().get(1).getOpcode());
    }

    @Test
    public void testReturnFloat() {
        Assert.assertEquals(Opcodes.FRETURN, returnMe(floatConstant(0F)).bake().compile().get(1).getOpcode());
    }

    @Test
    public void testReturnDouble() {
        Assert.assertEquals(Opcodes.DRETURN, returnMe(doubleConstant(0D)).bake().compile().get(1).getOpcode());
    }

    @Test
    public void testReturnObject() {
        Assert.assertEquals(Opcodes.ARETURN, returnMe(nullConstant(String.class)).bake().compile().get(1).getOpcode());
    }

    @Test
    public void testReturnNothing() {
        Assert.assertEquals(Opcodes.RETURN, returnMe(null).bake().compile().get(0).getOpcode());
    }
}
