package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpressions;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

import java.util.Collections;

import static cc.polymorphism.assembly.expressions.IRExpressions.instance;

public class IRNewInstanceExpressionTester {
    @Test
    public void testNewInstanceViaConstructor() throws Exception {
        var insns = instance(String.class.getConstructor()).bake().compile();
        var newOp = (TypeInsnNode) insns.get(0);
        Assert.assertEquals("java/lang/String", newOp.desc);
        Assert.assertEquals(Opcodes.DUP, insns.get(1).getOpcode());
        var invoke = (MethodInsnNode) insns.get(2);
        Assert.assertEquals("java/lang/String", invoke.owner);
        Assert.assertEquals("<init>", invoke.name);
        Assert.assertEquals("()V", invoke.desc);
    }

    @Test
    public void testNewInstanceViaWrappedType() throws Exception {
        var insns = IRExpressions.instance(WrappedType.from(String.class), Collections.emptyList(), Collections.emptyList()).bake().compile();
        var newOp = (TypeInsnNode) insns.get(0);
        Assert.assertEquals("java/lang/String", newOp.desc);
        Assert.assertEquals(Opcodes.DUP, insns.get(1).getOpcode());
        var invoke = (MethodInsnNode) insns.get(2);
        Assert.assertEquals("java/lang/String", invoke.owner);
        Assert.assertEquals("<init>", invoke.name);
        Assert.assertEquals("()V", invoke.desc);
    }
}
