package cc.polymorphism.assembly.expressions.predefined;

import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.IntInsnNode;

import java.util.stream.IntStream;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRNewArrayExpressionTester {
    @Test
    public void testForPrimitiveArray() {
        var block = newArray(int.class, intConstant(0), intConstant(1)).bake();
        var insns = block.compile();
        var expectedOpcodes = new int[]{
                Opcodes.ICONST_2,
                Opcodes.NEWARRAY,
                Opcodes.DUP,
                Opcodes.ICONST_0,
                Opcodes.ICONST_0,
                Opcodes.IASTORE,
                Opcodes.DUP,
                Opcodes.ICONST_1,
                Opcodes.ICONST_1,
                Opcodes.IASTORE,
        };

        IntStream.range(0, insns.size()).forEach(i -> Assert.assertEquals(expectedOpcodes[i], insns.get(i).getOpcode()));
        Assert.assertEquals(Opcodes.T_INT, ((IntInsnNode) insns.get(1)).operand);
    }

    @Test
    public void testForStringArray() {
        var block = newArray(String.class, stringConstant("tux"), stringConstant("tucks")).bake();
        var insns = block.compile();
        var expectedOpcodes = new int[]{
                Opcodes.ICONST_2,
                Opcodes.ANEWARRAY,
                Opcodes.DUP,
                Opcodes.ICONST_0,
                Opcodes.LDC,
                Opcodes.AASTORE,
                Opcodes.DUP,
                Opcodes.ICONST_1,
                Opcodes.LDC,
                Opcodes.AASTORE,
        };

        IntStream.range(0, insns.size()).forEach(i -> Assert.assertEquals(expectedOpcodes[i], insns.get(i).getOpcode()));
    }
}
