package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.exceptions.UncompilableNodeException;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.InsnNode;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRNegateExpressionTester {
    @Test
    public void testNegateBoolean() {
        var insn = (InsnNode) negate(booleanConstant(false)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.INEG, insn.getOpcode());
    }

    @Test
    public void testNegateInt() {
        var insn = (InsnNode) negate(intConstant(0)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.INEG, insn.getOpcode());
    }

    @Test
    public void testNegateLong() {
        var insn = (InsnNode) negate(longConstant(0L)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.LNEG, insn.getOpcode());
    }

    @Test
    public void testNegateFloat() {
        var insn = (InsnNode) negate(floatConstant(0F)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.FNEG, insn.getOpcode());
    }

    @Test
    public void testNegateDouble() {
        var insn = (InsnNode) negate(doubleConstant(0D)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.DNEG, insn.getOpcode());
    }

    @Test(expected = UncompilableNodeException.class)
    public void ensureExceptionThrownOnNonNegatableOperand() {
        negate(nullConstant(String.class)).bake();
    }
}
