package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.WrappedHandle;
import cc.polymorphism.assembly.WrappedType;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.List;

import static cc.polymorphism.assembly.expressions.IRExpressions.invokeDynamic;
import static cc.polymorphism.assembly.expressions.IRExpressions.stringConstant;

public class IRInvokeDynamicExpressionTester {
    @Test
    public void testInvokeDynamicWithMethodBootstrap() throws Exception {
        var method = IRInvokeDynamicExpressionTester.class.getMethod("dummyBootstrap", MethodHandles.Lookup.class, String.class, MethodType.class);
        var block = invokeDynamic(
                "tucks",
                List.of(stringConstant("tux"), stringConstant("tuks")),
                List.of(WrappedType.from(String.class), WrappedType.from(String.class)),
                WrappedType.from(String.class),
                method,
                Collections.emptyList()
        ).bake();
        var insns = block.compile();

        Assert.assertEquals("tux", ((LdcInsnNode) insns.get(0)).cst);
        Assert.assertEquals("tuks", ((LdcInsnNode) insns.get(1)).cst);
        Assert.assertEquals(Opcodes.INVOKEDYNAMIC, insns.get(2).getOpcode());

        var indy = (InvokeDynamicInsnNode) insns.get(2);
        var handle = indy.bsm;
        Assert.assertEquals("tucks", indy.name);
        Assert.assertEquals("(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", indy.desc);
        Assert.assertEquals(Type.getInternalName(IRInvokeDynamicExpressionTester.class), handle.getOwner());
        Assert.assertEquals("dummyBootstrap", handle.getName());
        Assert.assertEquals("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", handle.getDesc());
    }

    @Test
    public void testInvokeDynamicWithWrappedHandleBootstrap() throws Exception {
        var method = IRInvokeDynamicExpressionTester.class.getMethod("dummyBootstrap", MethodHandles.Lookup.class, String.class, MethodType.class);
        var block = invokeDynamic(
                "tucks",
                List.of(stringConstant("tux"), stringConstant("tuks")),
                List.of(WrappedType.from(String.class), WrappedType.from(String.class)),
                WrappedType.from(String.class),
                WrappedHandle.getInvokeStaticHandle(method),
                Collections.emptyList()
        ).bake();
        var insns = block.compile();

        Assert.assertEquals("tux", ((LdcInsnNode) insns.get(0)).cst);
        Assert.assertEquals("tuks", ((LdcInsnNode) insns.get(1)).cst);
        Assert.assertEquals(Opcodes.INVOKEDYNAMIC, insns.get(2).getOpcode());

        var indy = (InvokeDynamicInsnNode) insns.get(2);
        var handle = indy.bsm;
        Assert.assertEquals("tucks", indy.name);
        Assert.assertEquals("(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", indy.desc);
        Assert.assertEquals(Type.getInternalName(IRInvokeDynamicExpressionTester.class), handle.getOwner());
        Assert.assertEquals("dummyBootstrap", handle.getName());
        Assert.assertEquals("(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", handle.getDesc());
    }

    public static CallSite dummyBootstrap(MethodHandles.Lookup lookup, String name, MethodType type) {
        return null;
    }
}
