package cc.polymorphism.assembly.expressions.predefined;

import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodInsnNode;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRInvocationExpressionTester {
    @Test
    public void testInvokeStatic() throws Exception {
        var min = (MethodInsnNode) invokeStatic(DummyClass.class.getMethod("dummyStatic", String.class, int[].class)).bake().compile().get(0);
        Assert.assertEquals(Opcodes.INVOKESTATIC, min.getOpcode());
        Assert.assertEquals(Type.getInternalName(DummyClass.class), min.owner);
        Assert.assertEquals("dummyStatic", min.name);
        Assert.assertEquals("(Ljava/lang/String;[I)V", min.desc);
    }

    @Test
    public void testInvokeVirtual() throws Exception {
        var min = (MethodInsnNode) invokeVirtual(nullConstant(DummyClass.class), DummyClass.class.getMethod("dummyMethod", String.class, byte.class)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.INVOKEVIRTUAL, min.getOpcode());
        Assert.assertEquals(Type.getInternalName(DummyClass.class), min.owner);
        Assert.assertEquals("dummyMethod", min.name);
        Assert.assertEquals("(Ljava/lang/String;B)V", min.desc);
    }

    @Test
    public void testInvokeInterface() throws Exception {
        var min = (MethodInsnNode) invokeVirtual(nullConstant(DummyInterface.class), DummyInterface.class.getMethod("dummyInterfaceMethod", String.class, boolean.class)).bake().compile().get(1);
        Assert.assertEquals(Opcodes.INVOKEINTERFACE, min.getOpcode());
        Assert.assertEquals(Type.getInternalName(DummyInterface.class), min.owner);
        Assert.assertEquals("dummyInterfaceMethod", min.name);
        Assert.assertEquals("(Ljava/lang/String;Z)V", min.desc);
    }

    public interface DummyInterface {
        void dummyInterfaceMethod(String tux, boolean tucks);
    }

    public static class DummyClass implements DummyInterface {
        public void dummyMethod(String tux, byte tucks) {
        }

        public static void dummyStatic(String tux, int[] tucks) {
        }

        @Override
        public void dummyInterfaceMethod(String tux, boolean tucks) {
        }
    }
}
