package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.WrappedType;
import cc.polymorphism.assembly.expressions.IRExpressions;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.tree.TypeInsnNode;

import static cc.polymorphism.assembly.expressions.IRExpressions.instanceOf;
import static cc.polymorphism.assembly.expressions.IRExpressions.nullConstant;

public class IRInstanceOfExpressionTester {
    @Test
    public void testInstanceOfClass() {
        var tin = (TypeInsnNode) instanceOf(IRExpressions.nullConstant(Integer.class), Number.class).bake().compile().get(1);
        Assert.assertEquals("java/lang/Number", tin.desc);
    }

    @Test
    public void testInstanceOfWrappedType() {
        var tin = (TypeInsnNode) instanceOf(IRExpressions.nullConstant(Integer.class), WrappedType.from(Number.class)).bake().compile().get(1);
        Assert.assertEquals("java/lang/Number", tin.desc);
    }
}
