package cc.polymorphism.assembly.expressions.predefined;

import cc.polymorphism.assembly.WrappedType;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.FieldInsnNode;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRGetFieldExpressionTester {
    @Test
    public void testGetObjectField() throws Exception {
        var fin = (FieldInsnNode) getField(nullConstant(WrappedType.from(TestClass.class)), TestClass.class.getField("exampleField")).bake().compile().get(1);
        Assert.assertEquals(Opcodes.GETFIELD, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(TestClass.class), fin.owner);
        Assert.assertEquals("exampleField", fin.name);
        Assert.assertEquals("Ljava/lang/String;", fin.desc);
    }

    @Test
    public void testGetPrimitiveField() throws Exception {
        var fin = (FieldInsnNode) getField(nullConstant(WrappedType.from(TestClass.class)), TestClass.class.getField("examplePrimitiveField")).bake().compile().get(1);
        Assert.assertEquals(Opcodes.GETFIELD, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(TestClass.class), fin.owner);
        Assert.assertEquals("examplePrimitiveField", fin.name);
        Assert.assertEquals("B", fin.desc);
    }

    @Test
    public void testGetObjectStatic() throws Exception {
        var fin = (FieldInsnNode) getStatic(TestClass.class.getField("exampleStaticField")).bake().compile().get(0);
        Assert.assertEquals(Opcodes.GETSTATIC, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(TestClass.class), fin.owner);
        Assert.assertEquals("exampleStaticField", fin.name);
        Assert.assertEquals("Ljava/lang/String;", fin.desc);
    }

    @Test
    public void testGetPrimitiveStatic() throws Exception {
        var fin = (FieldInsnNode) getStatic(TestClass.class.getField("exampleStaticPrimitiveField")).bake().compile().get(0);
        Assert.assertEquals(Opcodes.GETSTATIC, fin.getOpcode());
        Assert.assertEquals(Type.getInternalName(TestClass.class), fin.owner);
        Assert.assertEquals("exampleStaticPrimitiveField", fin.name);
        Assert.assertEquals("B", fin.desc);
    }

    public static class TestClass {
        public String exampleField;
        public byte examplePrimitiveField;
        public static String exampleStaticField;
        public static byte exampleStaticPrimitiveField;
    }
}
