package cc.polymorphism.assembly.expressions.predefined;

import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRGetArrayElementExpressionTester {
    @Test
    public void testLoadBooleanElement() {
        var block = getArrayElement(nullConstant(boolean.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.IALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadByteElement() {
        var block = getArrayElement(nullConstant(byte.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.BALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadShortElement() {
        var block = getArrayElement(nullConstant(short.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.SALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadCharElement() {
        var block = getArrayElement(nullConstant(char.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.CALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadIntElement() {
        var block = getArrayElement(nullConstant(int.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.IALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadLongElement() {
        var block = getArrayElement(nullConstant(long.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.LALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadFloatElement() {
        var block = getArrayElement(nullConstant(float.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.FALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadDoubleElement() {
        var block = getArrayElement(nullConstant(double.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.DALOAD, insns.get(2).getOpcode());
    }

    @Test
    public void testLoadObjectElement() {
        var block = getArrayElement(nullConstant(String.class), intConstant(0)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ACONST_NULL, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.ICONST_0, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.AALOAD, insns.get(2).getOpcode());
    }
}
