package cc.polymorphism.assembly.expressions.predefined;

import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

import java.util.stream.IntStream;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRArrayLengthTester {
    @Test
    public void testForPrimitiveArray() {
        var block = arrayLength(newArray(int.class, intConstant(0), intConstant(1))).bake();
        var insns = block.compile();
        var expectedOpcodes = new int[]{
                Opcodes.ICONST_2,
                Opcodes.NEWARRAY,
                Opcodes.DUP,
                Opcodes.ICONST_0,
                Opcodes.ICONST_0,
                Opcodes.IASTORE,
                Opcodes.DUP,
                Opcodes.ICONST_1,
                Opcodes.ICONST_1,
                Opcodes.IASTORE,
                Opcodes.ARRAYLENGTH
        };

        IntStream.range(0, insns.size()).forEach(i -> Assert.assertEquals(expectedOpcodes[i], insns.get(i).getOpcode()));
    }

    @Test
    public void testForStringArray() {
        var block = arrayLength(newArray(String.class, stringConstant("tux"), stringConstant("tucks"))).bake();
        var insns = block.compile();
        var expectedOpcodes = new int[]{
                Opcodes.ICONST_2,
                Opcodes.ANEWARRAY,
                Opcodes.DUP,
                Opcodes.ICONST_0,
                Opcodes.LDC,
                Opcodes.AASTORE,
                Opcodes.DUP,
                Opcodes.ICONST_1,
                Opcodes.LDC,
                Opcodes.AASTORE,
                Opcodes.ARRAYLENGTH
        };

        IntStream.range(0, insns.size()).forEach(i -> Assert.assertEquals(expectedOpcodes[i], insns.get(i).getOpcode()));
    }
}
