package cc.polymorphism.assembly.expressions.predefined;

import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

import static cc.polymorphism.assembly.expressions.IRExpressions.*;

public class IRArithmeticExpressionTester {
    @Test
    public void testIntMathGeneration() {
        var block = intAdd(intConstant(5), intConstant(-3)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.ICONST_5, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.BIPUSH, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.IADD, insns.get(2).getOpcode());
    }

    @Test
    public void testLongMathGeneration() {
        var block = longMod(longConstant(11), longConstant(1)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.LDC, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.LCONST_1, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.LREM, insns.get(2).getOpcode());
    }

    @Test
    public void testFloatMathGeneration() {
        var block = floatMul(floatConstant(0F), floatConstant(2.1f)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.FCONST_0, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.LDC, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.FMUL, insns.get(2).getOpcode());
    }

    @Test
    public void testDoubleMathGeneration() {
        var block = doubleSub(doubleConstant(1D), doubleConstant(8.9999D)).bake();
        var insns = block.compile();

        Assert.assertEquals(Opcodes.DCONST_1, insns.get(0).getOpcode());
        Assert.assertEquals(Opcodes.LDC, insns.get(1).getOpcode());
        Assert.assertEquals(Opcodes.DSUB, insns.get(2).getOpcode());
    }
}
