package cc.polymorphism.assembly.expressions;

import cc.polymorphism.assembly.GenerationContext;
import org.junit.Assert;
import org.junit.Test;
import org.objectweb.asm.Opcodes;

public class IRVariableTester {
    @Test
    public void testGetIntTypeVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(byte.class).bake().compile();
        Assert.assertEquals(Opcodes.ILOAD, insns.get(0).getOpcode());
    }

    @Test
    public void testGetLongVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(long.class).bake().compile();
        Assert.assertEquals(Opcodes.LLOAD, insns.get(0).getOpcode());
    }

    @Test
    public void testGetFloatVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(float.class).bake().compile();
        Assert.assertEquals(Opcodes.FLOAD, insns.get(0).getOpcode());
    }

    @Test
    public void testGetDoubleVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(double.class).bake().compile();
        Assert.assertEquals(Opcodes.DLOAD, insns.get(0).getOpcode());
    }

    @Test
    public void testGetObjectVariable() {
        var context = new GenerationContext();
        var insns = context.newVariable(String.class).bake().compile();
        Assert.assertEquals(Opcodes.ALOAD, insns.get(0).getOpcode());
    }
}
