package cc.polymorphism.assembly.std;

import org.objectweb.asm.tree.ClassNode;

import javax.tools.*;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;

public class Compiler {
    public ClassNode compile(String className, String src) {
        final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        final DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<>();

        final JavaFileObject file = new JavaSourceFromString(className, src);
        final Iterable<? extends JavaFileObject> compilationUnits = Collections.singletonList(file);

        final StandardJavaFileManager stdFileManager = compiler.getStandardFileManager(null, null, null);

        final ClassFileManager fileManager = new ClassFileManager(stdFileManager);
        final JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, null, null, compilationUnits);

        final boolean success = task.call();

        if (success) {
            return Utility.makeClass(fileManager.jclassObject.getBytes());
        } else {
            return null;
        }
    }

    static class JavaSourceFromString extends SimpleJavaFileObject {
        final String code;

        JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + Kind.SOURCE.extension), Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return code;
        }
    }

    static class JavaClassObject extends SimpleJavaFileObject {
        protected ByteArrayOutputStream bos =
                new ByteArrayOutputStream();

        public JavaClassObject(String name, Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/')
                    + kind.extension), kind);
        }

        public byte[] getBytes() {
            return bos.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() {
            return bos;
        }
    }

    static class ClassFileManager extends ForwardingJavaFileManager<StandardJavaFileManager> {
        public JavaClassObject jclassObject;

        public ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public ClassLoader getClassLoader(Location location) {
            return null;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(Location location,
                                                   String className, JavaFileObject.Kind kind, FileObject sibling) {
            return jclassObject = new JavaClassObject(className, kind);
        }
    }
}